function [timetraces,xaxis] = timeseriesmergefunction(nfiles,ncell)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Reads all TimeTraces.txt files and merges them in one matrix to plot

%%% INPUT ARGUMENTS

%%% Timetraces files must be saved in folder as '1.txt','2.txt' and so on

%%% nominalinterval = interval between frames set on microscope (in ms)
%%% exptime = exposure time to take each image on microscope (in ms)
%%% nfiles = number of timetraces files to merge
%%% ncell = number of cells

%%% OUTPUT ARGUMENTS

%%% timetraces = file with all the time traces (1 col = 1 cell)
%%% row containing x-axis labels (actual times)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all
clc

%%% Asks for manual input of nominal interval and exposure time

prompt = 'What is the nominal interval (in ms)?\n';
nominalinterval = input(prompt);
prompt1 = 'What is the exposure time (in ms)?\n';
exptime = input(prompt1);
clc

interval = nominalinterval + exptime; %actual interval between frames

%%% Reads first file
filename = '1.csv';
timetraces = csvread(filename,1,0); 
timetraces = timetraces(:,1:end-2);
timetraces(isnan(timetraces))=[0]; % possible NaN are filled with 0

nframes = size(timetraces,1);
frames = 1:nframes; %defines frames vector
xaxis = interval*frames/1000; %time axis in s

clearvars filename fileID ans interval frames;

ii=0; 

  for ii=2:nfiles
      
      filename =[num2str(ii) '.csv'];
      a = csvread(filename,1,0); 
      a = a(:,1:end-2);
      a(isnan(a))=[0]; % possible NaN are filled with 0
      timetraces=[timetraces a]; 
            
      clearvars a filename
      
  end
  
  if size(timetraces,2) ~= ncell
      fprintf('Error! Timetraces dimention not correct\r\n')
  end
  
end